#pragma once

#include "Device.h"
#include "DSP.h"

void sysTimeToFileName(SYSTEMTIME *st, CString &fileName);
bool DirectoryExists(CString &path);
int pow2(int n);
int log2(int n);

class XMLFile;
class DiskController;

class CRFDoc : public CDocument
{
protected: // create from serialization only
	CRFDoc();
	DECLARE_DYNCREATE(CRFDoc)

public:
	static UINT ThreadEntry(LPVOID param);
	UINT MainThread();

	bool IsRecording(void) const { return recording; }
	const bbSettings_t* GetSettings(void) const { return &settings; }
	const signalStats_t* GetStats(void) const { return &sigStats; }
	const float* GetSweep(int *len = 0) const { 
		if(len) { *len = dsp.Size(); }
		return dsp.GetResults(); }

	void InvalidateView() const;
	void Reconfigure(const bbSettings_t &newSettings);
	void UpdateViewSettings(const viewSettings_t &vs);
	bool StartStopRecord();
	void WriteOutXML();
	bool IsOverload() {
		if(overloaded) {
			overloaded = false; 
			return true; }
		else return false; }

private:
	bbDevice device;
	DiskController *disk;

	XMLFile *xmlFile;
	bbSettings_t settings;
	viewSettings_t viewSettings;
	signalStats_t sigStats;
	DSP dsp;

	float *raw;
	int buffersSaved;
	int triggers[17*4];
	short *rawshorts;
	int packetCount; // Running record packet count

	bool programRunning;
	bool recording;
	bool reconfigure;
	bool overloaded;
	CWinThread *mainThread;
// Overrides
public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CRFDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnCloseDocument();
};


